<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \Carbon\Carbon;

use App\Models\UserGroup;

class UserGroupController extends Controller
{

    public function addGroup(Request $request)
	{
        $group =  new UserGroup();
        $group->group_name       = $request->group_name;
        if($request->limite){
            $group->expire_date = "none";
        }else{
            $group->expire_date      =  Carbon::parse($request->expire_date)->format('Y-m-d') ;
        }
        $group->save();
		return redirect(route('usergroup_list'));
	}
    public function removeGroup($id)
	{
        $group =  UserGroup::find($id);
        $group->delete();
		return redirect(route('usergroup_list'));
	}
    public function updateGroup($id)
	{
        $group =  UserGroup::find($id);
        $group->group_name       = request('group_name',$group->group_name);
        if(request('limite')){
            $group->expire_date = "none";
        }else{
            $group->expire_date      =  Carbon::parse(request('expire_date'))->format('Y-m-d') ;
        }
        $group->save();
		return redirect(route('usergroup_list'));
	}





}
