<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Qbank;
use App\Models\QOption;


class QuestionController extends Controller
{

    public function addQuestion(Request $request)
	{
        $question = new Qbank();
        $question->question             = $request->question;
        $question->description          = $request->explain;
        $question->question_category_id = $request->category_id;
        $question->difficult_level_id   = $request->level_id;
        $question->save();

        if($request->choice_1 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_1;
            if($request->response == 1){
                $option->score = 1;
            }
            $option->save();
        }
        if($request->choice_2 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_2;
            if($request->response == 2){
                $option->score = 1;
            }
            $option->save();
        }
        if($request->choice_3 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_3;
            if($request->response == 3){
                $option->score = 1;
            }
            $option->save();
        }
        if($request->choice_4 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_4;
            if($request->response == 4){
                $option->score = 1;
            }
            $option->save();
        }
		return redirect(route('questions_list'));
	}
    public function editQuestion($id,Request $request)
	{

        $question = Qbank::find($id);
        $question->question             = request('question',  $question->question);
        $question->description          = request('explain', $question->description);
        $question->question_category_id = request('category_id', $question->question_category_id);
        $question->difficult_level_id   = request('level_id', $question->difficult_level_id);
        $question->save();

        QOption::where('qbank_id', $question->id )->delete();

        if($request->choice_1 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_1;
            if($request->response == 1){
                $option->score = 1;
            }
            $option->save();
        }
        if($request->choice_2 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_2;
            if($request->response == 2){
                $option->score = 1;
            }
            $option->save();
        }
        if($request->choice_3 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_3;
            if($request->response == 3){
                $option->score = 1;
            }
            $option->save();
        }
        if($request->choice_4 != null){
            $option = new QOption();
            $option->qbank_id = $question->id;
            $option->option_value = $request->choice_4;
            if($request->response == 4){
                $option->score = 1;
            }
            $option->save();
        }
		return redirect(route('questions_list'));
	}

    public function removeQuestion($id)
	{
        $question = Qbank::find($id);
        QOption::where('qbank_id', $question->id )->delete();
        $question->delete();
        return back();


    }




}
