<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\UserGroup;
use App\Models\DifficultLevel;
use App\Models\QuestionCategory;
use App\Models\Qbank;
use App\Models\Quiz;
use App\Models\Meta;
use App\Models\EmailQueue;

use App\Mail\GlobalMail;
use Illuminate\Support\Facades\Mail;

class RouteController extends Controller
{

    public function home()
	{
		return redirect()->route('login');
	}
    public function index()
	{
		return view('pages.dashboard');
	}
    public function login()
	{
		return view('auth.login');
	}
    public function userList()
	{
        $users = User::orderBy('id','desc')->paginate(30);
		return view('pages.users.index',compact('users'));
	}
    public function getAddUserPage()
	{
        $groups = UserGroup::get();
		return view('pages.users.add',compact('groups') );
	}
    public function getEditUserPage($id)
	{
        $user = User::find($id);
        $groups = UserGroup::get();
		return view('pages.users.edit',compact('user','groups') );
	}
    public function questionsList()
	{
        $questions = Qbank::get();
        return view('pages.questions.index',compact('questions'));
	}
    public function getAddQuestionPage()
	{
        $levels = DifficultLevel::get();
        $categories = QuestionCategory::get();
		return view('pages.questions.add',compact('levels','categories'));
	}
    public function getEditQuestionPage($id)
	{
        $levels = DifficultLevel::get();
        $categories = QuestionCategory::get();
        $question = Qbank::find($id);
		return view('pages.questions.edit',compact('levels','categories','question'));
	}
    public function getAddCategoryPage( )
	{
        $category = null;
        if(request('id')){
        	$category = QuestionCategory::find(request('id'));
		}
		return view('pages.question_categories.add',compact('category') );
	}
    public function getEditCategoryPage($id)
	{
        $category = QuestionCategory::find($id);
		return view('pages.question_categories.edit',compact('category') );
	}
    public function categoriesList()
	{
        $categories = QuestionCategory::where('parent_id','0')->get();
		return view('pages.question_categories.index',compact('categories'));
	}
    public function subCategoriesList($id)
	{
        $sub_category = QuestionCategory::find($id);
        $categories = QuestionCategory::where('parent_id',$id)->get();
		return view('pages.question_categories.sub_categories',compact('categories','sub_category'));
	}
    public function userGroupsList()
	{
        $groups = UserGroup::paginate(20);
		return view('pages.user_groups.index',compact('groups'));
	}
    public function getAddGroupPage()
	{
		return view('pages.user_groups.add');
	}
    public function getEditGroupPage($id)
	{
        $group = UserGroup::find($id);
		return view('pages.user_groups.edit',compact('group'));
	}
    public function quizList()
	{
        $quizzes = Quiz::paginate(15);
		return view('pages.quiz.index',compact('quizzes'));
	}
    public function getAddQuizPage()
	{
        $groups = UserGroup::get();
        $categories = QuestionCategory::get();
		return view('pages.quiz.add',compact('categories','groups'));
	}
    public function resultList()
	{
		return view('pages.results.index');
	}
    public function settings()
	{
		return view('pages.settings.index');
	}
    public function generalReport()
	{
		return view('pages.general_report.index');
	}
    public function configure()
	{
        $groups = UserGroup::get();
        $metas = Meta::get();
		return view('pages.configure.index',compact('groups','metas'));
	}
    public function configurePost( )
	{
        foreach(request()->all()  as $key=>$value){
            Meta::where("name", $key)->update(['value'=> $value]);
        }
        return back();
	}
    public function email()
	{
        $groups = UserGroup::get();
		return view('pages.settings.email',compact('groups'));
	}
    public function sendEmail()
	{

        foreach(request('groups') as $group_id){
            $email_list =  User::where('group_id',$group_id)->select('email')->pluck('email');
            foreach ($email_list as $email) {
                Mail::to($email)->send(new GlobalMail(request('subject'),request('message')));
            }
        }
        return back();
	}
    public function emailQueue()
    {
        $emails = EmailQueue::get();
        return view('pages.settings.email_queue',compact('emails'));
    }
    public function emailDetails($id)
    {
        $email = EmailQueue::find($id);
        return view('pages.settings.email_details',compact('email'));
    }
}
