<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \Carbon\Carbon;

use App\Models\User;
use App\Models\UserGroup;

class UserController extends Controller
{

    public function addUser(Request $request)
	{
        $user =  new User();
        $user->username         = $request->username;
        $user->first_name       = $request->firstname;
        $user->last_name        = $request->lastname;
        $user->email            = $request->email;
        $user->password         = bcrypt($request->password);
        $user->mobile           = $request->mobile;
        $user->gid              = $request->group_id;
        $user->expire_date      =  Carbon::parse($request->end_date)->format('Y-m-d') ;
        $user->institute_id     = 1;

        $user->save();
		return redirect(route('user_list'));
	}

    public function removeUser($id)
	{
        $user = User::find($id);
        $user->delete();
		return back();
	}

     public function updateUser($id)
	{
        $user =  User::find($id);
        $user->username         = request('username', $user->username);
        $user->first_name       = request('firstname', $user->first_name);
        $user->last_name        = request('lastname', $user->last_name);
        $user->email            = request('email', $user->email);
        $user->password         = bcrypt(request('password'));
        $user->mobile           = request('mobile', $user->mobile);
        $user->gid              = request('group_id', $user->gid);
        $user->credit           = request('credit', $user->credit);
        $user->expire_date      = Carbon::parse(request('expire_date'))->format('Y-m-d') ;
        $user->institute_id     = 1;

        $user->save();
		return redirect(route('user_list'));
	}

}
