<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('username');
            $table->string('password',100);
            $table->string('email')->nullable()->default('NULL');
            $table->string('first_name')->nullable()->default('NULL');
            $table->string('last_name',100)->nullable()->default('NULL');
            $table->string('credit',100)->nullable()->default('NULL');
            $table->integer('group_id')->nullable();
            $table->integer('su')->default('1');
            $table->tinyText('su_permissions')->nullable();
            $table->integer('main_su_admin')->default('0');
            $table->integer('institute_id');
            $table->string('mobile',20)->nullable()->default('NULL');
            $table->string('verification_code',20)->nullable()->default('NULL');
            $table->string('verification_time',40)->nullable()->default('NULL');
            $table->string('verified_mobile',20)->nullable()->default('NULL');
            $table->tinyInteger('is_verified')->default('1');
            $table->string('header_css',35)->nullable()->default('NULL');
            $table->string('sidebar_css',35)->nullable()->default('NULL');
            $table->string('last_login',100)->nullable();
            $table->tinyInteger('resetPassword')->default('0');
            $table->string('resetCode',15)->nullable()->default('NULL');
            $table->string('region')->nullable()->default('NULL');
            $table->date('expire_date')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
