<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('institute_datas', function (Blueprint $table) {
            $table->id();
            $table->integer('su_institute_id');
            $table->string('organization_name',200);
            $table->string('logo',100)->defult('logo.png');
            $table->text('contact_info');
            $table->integer('active_till');
            $table->integer('status')->default(1);
            $table->text('description',200);
            $table->string('custom_domain',1000)->default(Null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('institute_datas');
    }
};
