<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quizzes', function (Blueprint $table) {
            $table->id();
            $table->integer('quid');
            $table->string('quiz_name',100);
            $table->text('description');
            $table->string('start_time',100);
            $table->string('end_time',100);
            $table->integer('duration');
            $table->string('pass_percentage',5);
            $table->integer('test_type');
            $table->string('credit',10);
            $table->integer('view_answer');
            $table->integer('max_attempts');
            $table->string('correct_score',4);
            $table->string('incorrect_score',4);
            $table->integer('institute_id')->default('1');
            $table->string('test_t',100)->default('Real');
            $table->integer('answered_correct')->default('0');
            $table->integer('answered_incorrect')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quizzes');
    }
};
