<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_result_questions', function (Blueprint $table) {
            $table->id();
            $table->integer('quiz_id');
            $table->integer('category_id');
            $table->integer('question_id');
            $table->integer('user_id');
            $table->integer('score')->default('0');
            $table->string('session');
            $table->integer('group_id');
            $table->integer('result_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_result_questions');
    }
};
