@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">إضافة سؤال جديد</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->

                <div class="nk-block">
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="{{route('question.post')}}" method="post">
                                        @csrf

                                        <div id="accordion" class="accordion">
                                            <div class="accordion-item">
                                                <a href="#" class="accordion-head collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#accordion-item-2">
                                                    <h6 class="title pe-4"> إظهار التصنيفات</h6>
                                                    <span class="accordion-icon"></span>
                                                </a>
                                                <div class="accordion-body collapse" id="accordion-item-2"
                                                    data-bs-parent="#accordion">
                                                    <div class="accordion-inner">
                                                        <ul class="custom-control-group ">
                                                         @foreach($categories as $category)
                                                                <li class="{{$category->parent_id ==0?'w-100':''}}">
                                                                    <div class="custom-control custom-radio custom-control-pro no-control pb-1">
                                                                        <input type="radio" class="custom-control-input"
                                                                            name="category_id" id="categ-{{$category->id}}"
                                                                            value="{{$category->id}}"  required="">
                                                                        <label class="{{$category->parent_id ==0?'':'custom-control-label'}}" for="categ-{{$category->id}}">
                                                                            {{$category->category_name}}
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                                @endforeach
                                                            </ul>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <label class="form-label">المستوى</label>
                                            <select class="form-select" name="level_id" required="">
                                                <option value="">الرجاء الإختيار</option>
                                                @foreach($levels as $level)
                                                    <option value="{{ $level->id }}">{{ $level->level_name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group" id="question">
                                            <label class="form-label" for="cf-question">السؤال</label>
                                            <textarea name="question" class="summernote-basic"></textarea >
                                        </div>

                                        <div class="form-group" id="explain" >
                                            <label class="form-label" for="cf-explain">الشرح (إختياري)</label>
                                            <textarea name="explain" class="summernote-basic"></textarea >
                                        </div>

                                        <div class="card card-bordered card-preview">
                                            <div class="card-inner">
                                                <label class="form-label" for="cf-option1">الخيارات :</label>
                                                <div class="form-group" id="choice_1">
                                                    <div class="custom-control custom-control-sm custom-radio mb-2">
                                                        <input type="radio" id="customRadio1" name="response" value="1"
                                                            class="custom-control-input">
                                                        <label class="custom-control-label" for="customRadio1">هذه هي
                                                            الإجابة الصحيحة</label>
                                                    </div>
                                                    <textarea name="choice_1" class="summernote-basic"></textarea>
                                                </div>
                                                <div class="form-group" id="choice_2">
                                                    <div class="custom-control custom-control-sm custom-radio mb-2">
                                                        <input type="radio" id="customRadio2" name="response" value="2"
                                                            class="custom-control-input">
                                                        <label class="custom-control-label" for="customRadio2">هذه هي
                                                            الإجابة الصحيحة</label>
                                                    </div>
                                                    <textarea  name="choice_2" class="summernote-basic"></textarea>
                                                </div>
                                                <div class="form-group" id="choice_3">
                                                    <div class="custom-control custom-control-sm custom-radio mb-2">
                                                        <input type="radio" id="customRadio3" name="response" value="3"
                                                            class="custom-control-input">
                                                        <label class="custom-control-label" for="customRadio3">هذه هي
                                                            الإجابة الصحيحة</label>
                                                    </div>
                                                    <textarea  name="choice_3" class="summernote-basic"></textarea>
                                                </div>
                                                <div class="form-group" id="choice_4">
                                                    <div class="custom-control custom-control-sm custom-radio mb-2">
                                                        <input type="radio" id="customRadio4" name="response" value="4"
                                                            class="custom-control-input">
                                                        <label class="custom-control-label" for="customRadio4">هذه هي
                                                            الإجابة الصحيحة</label>
                                                    </div>
                                                    <textarea name="choice_4" class="summernote-basic"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group text-center m-2">
                                            <button type="submit" class="btn btn-lg btn-primary">تحديث البيانات</button>
                                        </div>
                                    </form>


                                </div>
                            </div>

                        </div>

                        {{-- </div> --}}
                        {{-- </div> --}}
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
@section('styles')
<link rel="stylesheet" href="{{ asset('assets/css/editors/summernote.css') }}">
@endsection
@section('scripts')
<script src="{{ asset('assets/js/editors/summernote.js') }}"></script>

@endsection
