@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">تعديل سؤال</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->

                <div class="nk-block">
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="{{ route('question.put',$question->id) }}" method="post">
                                        @csrf

                                        <div id="accordion" class="accordion">
                                            <div class="accordion-item">
                                                <a href="#" class="accordion-head collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#accordion-item-2">
                                                    <h6 class="title pe-4"> إظهار التصنيفات</h6>
                                                    <span class="accordion-icon"></span>
                                                </a>
                                                <div class="accordion-body" id="accordion-item-2"
                                                    data-bs-parent="#accordion">
                                                    <div class="accordion-inner">
                                                        <ul class="custom-control-group ">
                                                            @foreach($categories as $category)
                                                                <li
                                                                    class="{{ $category->parent_id ==0?'w-100':'' }}">
                                                                    <div
                                                                        class="custom-control custom-radio custom-control-pro no-control pb-1">
                                                                        <input type="radio" class="custom-control-input"
                                                                            name="category_id"
                                                                            id="categ-{{ $category->id }}"
                                                                            {{ $question->question_category->category_name == $category->category_name ? "checked":"" }}
                                                                            value="{{ $category->id }}" required="">
                                                                        <label
                                                                            class="{{ $category->parent_id ==0?'':'custom-control-label' }}"
                                                                            for="categ-{{ $category->id }}">
                                                                            {{ $category->category_name }}
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <label class="form-label">المستوى</label>
                                            <select class="form-select" name="level_id" required="">
                                                <option value="">الرجاء الإختيار</option>
                                                @foreach($levels as $level)
                                                    <option value="{{ $level->id }}"
                                                        {{ $question->difficult_level->level_name == $level->level_name ? "selected":"" }}>
                                                        {{ $level->level_name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group" id="question">
                                            <label class="form-label" for="cf-question">السؤال</label>
                                            <textarea name="question" class="summernote-basic">
                                                {{ $question->question }}
                                            </textarea>
                                        </div>

                                        <div class="form-group" id="explain">
                                            <label class="form-label" for="cf-explain">الشرح (إختياري)</label>
                                            <textarea name="explain" class="summernote-basic">
                                                {{ $question->description }}
                                            </textarea>
                                        </div>


                                        <div class="card card-bordered card-preview">
                                            <div class="card-inner">
                                                <label class="form-label">الخيارات :</label>
                                                @foreach($question->options as $index => $option)
                                                    <div class="form-group" id="choice_{{ $option->id }}">
                                                        <div class="custom-control custom-control-sm custom-radio mb-2">
                                                            <input type="radio" id="customRadio{{$index+1}}" name="response"
                                                                value="{{$index+1}}" {{ $option->score ? 'checked':'' }} class="custom-control-input"
                                                                 >
                                                            <label class="custom-control-label" for="customRadio{{$index+1}}">هذه
                                                                هي
                                                                الإجابة الصحيحة
                                                            </label>
                                                        </div>
                                                        <textarea name="choice_{{$index+1}}"
                                                            class="summernote-basic">{{ $option->option_value }}</textarea>
                                                    </div>
                                                @endforeach

                                            </div>
                                        </div>

                                        <div class="form-group text-center m-2">
                                            <button type="submit" class="btn btn-lg btn-primary">تحديث البيانات</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
@section('styles')
<link rel="stylesheet" href="{{ asset('assets/css/editors/summernote.css') }}">
@endsection
@section('scripts')
<script src="{{ asset('assets/js/editors/summernote.js') }}"></script>

@endsection
