@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">إضافة إختبار جديد</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->

                <div class="nk-block">
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="{{ route('quiz.post') }}" method="post">
                                        @csrf
                                        <div class="form-group">
                                            <label class="form-label" for="cf-name">اسم الإختبار</label>
                                            <input type="text" class="form-control" id="cf-name" name="quiz_name">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">النوع</label>
                                            <select class="form-select" name="type_t" required="">
                                                <option value="Practice">تجريبي</option>
                                                <option value="Real">حقيقي</option>
                                            </select>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4 form-group">
                                                <label class="form-label" for="cf-duration">زمن الإختبار</label>
                                                <input type="number" class="form-control" id="cf-duration"
                                                    name="duration">
                                            </div>
                                            <div class="col-md-4 mt-5 pe-0">
                                                <label>دقيقة | 0 = لا نهائي</label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-start">تاريخ البداية</label>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control date-picker"  id="cf-start-date" name="start_date" placeholder="تاريخ البداية">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control time-picker"  id="cf-start-time" name="start_time" placeholder="وقت البداية">
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-end-time">تاريخ النهاية</label>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control date-picker"  id="cf-end-date" name="end_date" placeholder="تاريخ النهاية">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-control-wrap">
                                                        <input type="text" class="form-control time-picker"  id="cf-end-time" name="end_time" placeholder="وقت النهاية">
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-group col-md-4">
                                            <label class="form-label" for="cf-number">أقصى عدد للمحاولات لكل
                                                مستخدم</label>
                                            <input type="number" min="1" max="1000" class="form-control" id="cf-number"
                                                name="max_attempts">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="description">وصف الإختبار</label>
                                            <textarea name="description" class="summernote-basic"></textarea>
                                        </div>
                                        <div class="row form-group">
                                            <div class="col-md-3">
                                                <label class="form-label">النسبة المطلوبة للنجاح</label>
                                                <select class="form-select" name="pass_percentage" required="">
                                                    @for($i=0;$i<=100;$i++)
                                                        <option value="{{ $i }}">{{ $i }}</option>
                                                    @endfor
                                                </select>
                                            </div>
                                            <div class="col-md-1 mt-5 pe-0">
                                                <label>%</label>
                                            </div>
                                        </div>
                                        <hr>
                                        <div id="accordion" class="accordion form-group">
                                            <div class="accordion-item">
                                                <a href="#" class="accordion-head collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#accordion-item-1">
                                                    <h6 class="title pe-4"> مجموعات المُستخدمين</h6>
                                                    <span class="accordion-icon"></span>
                                                </a>
                                                <div class="accordion-body collapse" id="accordion-item-1"
                                                    data-bs-parent="#accordion">
                                                    <div class="accordion-inner">
                                                        <ul class="custom-control-group ">
                                                            @foreach($groups as $group)
                                                                <li>
                                                                    <div class="custom-control custom-checkbox custom-control-pro no-control pb-1">
                                                                        <input type="checkbox" class="custom-control-input" name="groups[]"
                                                                            id="categ-{{ $group->id }}" value="{{ $group->id }}">
                                                                        <label class="custom-control-label" for="categ-{{ $group->id }}">
                                                                            {{ $group->group_name }}
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-3 form-group">
                                                <label class="form-label"> نوع الإختبار</label>
                                                <div class="form-control-wrap">
                                                    <ul class="custom-control-group">
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="type_t" id="activated" value="0"
                                                                    required="">
                                                                <label class="custom-control-label"
                                                                    for="activated">مجاني</label>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="type_t" id="desactivated" value="1"
                                                                    required="">
                                                                <label class="custom-control-label"
                                                                    for="desactivated">مدفوع</label>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="mb-1" for="credit">القيمة</label>
                                                <input type="text" class="form-control" id="credit"
                                                    name="credit">
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-3 form-group">
                                                <label class="form-label"> السماح برؤية الأجوبة</label>
                                                <div class="form-control-wrap">
                                                    <ul class="custom-control-group">
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="view_answer" id="yes" value="1" required="">
                                                                <label class="custom-control-label" for="yes">نعم
                                                                </label>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="view_answer" id="no" value="0" required="">
                                                                <label class="custom-control-label" for="no">لا</label>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="example-alert mb-1">
                                            <div class="alert alert-danger alert-icon">
                                                رجاءً قم بإختيار الأسئلة بحذر, فلن تتمكن من تعديل الأسئلة بعد
                                                إضافة الإختبار.
                                            </div>
                                        </div>
                                        <div id="accordion" class="accordion form-group">
                                            <div class="accordion-item">
                                                <a href="#" class="accordion-head collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#accordion-item-2">
                                                    <h6 class="title pe-4"> الأسئلة</h6>
                                                    <span class="accordion-icon"></span>
                                                </a>
                                                <div class="accordion-body collapse" id="accordion-item-2"
                                                    data-bs-parent="#accordion">
                                                    <div class="accordion-inner">
                                                        <ul class="custom-control-group ">
                                                            @foreach($categories as $category)
                                                                <li
                                                                    class="{{ $category->parent_id ==0?'w-100':'' }}">
                                                                    <div
                                                                        class="custom-control custom-checkbox custom-control-pro no-control pb-1">
                                                                        <input type="checkbox" class="custom-control-input"
                                                                            name="questions[]" id="categ-{{ $category->id }}"
                                                                            value="{{ $category->id }}" >
                                                                        <label
                                                                            class="{{ $category->parent_id ==0?'':'custom-control-label' }}"
                                                                            for="categ-{{ $category->id }}">
                                                                            {{ $category->category_name }}
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="form-group text-center">
                                            <button type="submit" class="btn btn-lg btn-primary">
                                                إضافة الإختبار
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
@section('styles')
<link rel="stylesheet" href="{{ asset('assets/css/editors/summernote.css') }}">
@endsection
@section('scripts')
<script src="{{ asset('assets/js/editors/summernote.js') }}"></script>

@endsection
