@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">الإختبارات</h3>
                        </div>
                        <!-- .nk-block-head-content -->
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1"
                                    data-target="pageMenu"><em class="icon ni ni-menu-alt-r"></em></a>
                                <div class="toggle-expand-content" data-content="pageMenu">
                                    <ul class="nk-block-tools g-3">
                                        <li>
                                            <a href="{{ route('quiz.add') }}" class="btn btn-primary">
                                                <em class="icon ni ni-plus"></em>
                                                <span>إضافة جديد</span>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div><!-- .toggle-wrap -->
                        </div>
                        <!-- .nk-block-head-content -->
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner position-relative card-tools-toggle">
                                <div class="card-title-group">
                                    <div class="card-tools me-n1">
                                        <ul class="btn-toolbar gx-1">
                                            <li>
                                                <a href="#" class="btn btn-icon search-toggle toggle-search"
                                                    data-target="search"><em class="icon ni ni-search"></em></a>
                                            </li><!-- li -->
                                        </ul><!-- .btn-toolbar -->
                                    </div><!-- .card-tools -->
                                </div><!-- .card-title-group -->
                                <div class="card-search search-wrap" data-search="search">
                                    <div class="card-body">
                                        <div class="search-content">
                                            <a href="#" class="search-back btn btn-icon toggle-search"
                                                data-target="search"><em class="icon ni ni-arrow-left"></em></a>
                                            <input type="text" class="form-control border-transparent form-focus-none"
                                                placeholder="Search by user or email">
                                            <button class="search-submit btn btn-icon"><em
                                                    class="icon ni ni-search"></em></button>
                                        </div>
                                    </div>
                                </div><!-- .card-search -->
                            </div><!-- .card-inner -->
                            <div class="card-inner p-0">
                                <div class="nk-tb-list nk-tb-ulist is-compact">
                                    <div class="nk-tb-item nk-tb-head">

                                        <div class="nk-tb-col"><span class="sub-text">#</span></div>
                                        <div class="nk-tb-col tb-col-lg"><span class="sub-text">اسم الإختبار</span>
                                        </div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">عدد الأسئلة</span></div>
                                        <div class="nk-tb-col tb-col-sm"><span class="sub-text">تاريخ النهاية</span>
                                        </div>
                                        <div class="nk-tb-col tb-col-sm"><span class="sub-text">زمن الإختبار</span>
                                        </div>
                                        <div class="nk-tb-col tb-col-sm"><span class="sub-text">النوع</span></div>
                                        <div class="nk-tb-col tb-col-sm"><span class="sub-text">دخول</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">تحكم</span></div>

                                    </div>
                                    <!-- .nk-tb-item -->
                                    @foreach($quizzes as $index => $quiz)
                                        <div class="nk-tb-item">
                                            <div class="nk-tb-col">
                                                <span>{{$index+1}}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span class="tb-lead">{{$quiz->quiz_name}}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span>90</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span>{{$quiz->end_time}}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span>{{$quiz->duration}} دقيقة</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span>{{$quiz->test_t = 'Real' ? 'حقيقي' : 'تجريبي'}}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <a href="" class="btn btn-dim btn-sm  btn-outline-primary">
                                                    <span>دخول الإختبار</span>
                                                </a>
                                            </div>
                                            <div class="nk-tb-col">
                                                <a href="" class="btn btn-sm btn-outline-info">
                                                    <span>تعديل</span>
                                                    <em class="icon text-info ni ni-pen2"></em>
                                                </a>
                                                <a href="" class="btn btn-sm btn-outline-success">
                                                    <span> تصدير WORD</span>
                                                    <em class="icon text-success ni ni-upload"></em>
                                                </a>
                                                <a href="" class="btn btn-sm btn-outline-danger">
                                                    <span>حذف</span>
                                                    <em class="icon text-danger ni ni-trash"></em>
                                                </a>
                                            </div>

                                        </div>
                                    @endforeach
                                    <!-- .nk-tb-item -->
                                </div><!-- .nk-tb-list -->
                            </div><!-- .card-inner -->
                            <div class="card-inner">
                                <ul class="pagination justify-content-center justify-content-md-start">
                                    {{ $quizzes->onEachSide(1)->links() }}
                                </ul><!-- .pagination -->
                            </div><!-- .card-inner -->
                        </div><!-- .card-inner-group -->
                    </div><!-- .card -->
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
