@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">الرسائل المجدولة</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->

                <div class="nk-block">
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            @if($emails->count() == 0)
                                <div class="alert alert-secondary  alert-icon">
                                    لم يتم العثور على أي نتائج!.
                                </div>
                            @else
                                <div class="nk-tb-list nk-tb-ulist is-compact">
                                    <div class="nk-tb-item nk-tb-head">

                                        <div class="nk-tb-col"><span class="sub-text">#</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">الموضوع </span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">تحكم</span></div>

                                    </div>

                                    @foreach($emails as $index => $email)
                                        <div class="nk-tb-item">
                                            <div class="nk-tb-col">
                                                <span>{{ $index+1 }}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                {{$email->subject}}
                                            </div>
                                            <div class="nk-tb-col w-25">
                                                <a href="{{route('email_details',$email->id)}}" class="btn btn-sm btn-outline-info">
                                                    <span>دخول </span>
                                                    <em class="icon text-info ni ni-eye"></em>
                                                </a>
                                                <a href="" class="btn btn-sm btn-outline-danger">
                                                    <span>حذف</span>
                                                    <em class="icon text-danger ni ni-trash"></em>
                                                </a>
                                            </div>

                                        </div>
                                    @endforeach
                                </div>
                            @endif

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
