@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">تعديل مستخدم</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    {{-- <div class="card card-bordered card-preview"> --}}
                    {{-- <div class="card-inner"> --}}
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">


                                    <form action="{{ route('user.update',$user->id) }}"
                                        method="post">
                                        @csrf
                                        <div class="form-group">
                                            <label class="form-label" for="cf-full-name">اسم المستخدم</label>
                                            <input type="text" class="form-control" id="cf-full-name" name="username"
                                                value="{{ $user->username }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-phone-no">رقم الجوال</label>
                                            <input type="text" class="form-control" id="cf-phone-no" name="mobile"
                                                value="{{ $user->mobile }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-first-name">الإسم الأول</label>
                                            <input type="text" class="form-control" id="cf-first-name" name="firstname"
                                                value="{{ $user->first_name }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-last-name">اسم العائلة</label>
                                            <input type="text" class="form-control" id="cf-last-name" name="lastname"
                                                value="{{ $user->last_name }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-email">البريد الإلكتروني</label>
                                            <input type="email" class="form-control" id="cf-email" name="email"
                                                value="{{ $user->email }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-password">كلمة المرور</label>
                                            <input type="password" class="form-control" id="cf-password" name="password"
                                                value="{{ $user->password }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">المنطقة</label>
                                            <select class="form-select" name="region" required="">
                                                <option value="">الرجاء الإختيار</option>
                                                <option value="الرياض">الرياض</option>
                                                <option value="مكة">مكة</option>
                                                <option value="جدة">جدة</option>
                                                <option value="الخبر">الخبر</option>
                                                <option value="الدمام">الدمام</option>
                                                <option value="القصيم">القصيم</option>
                                                <option value="المنطقة الشماليه">المنطقة الشماليه</option>
                                                <option value="المنطقه الجنوبيه">المنطقه الجنوبيه</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="cf-credit">الرصيد</label>
                                            <input type="text" class="form-control" id="cf-credit" name="credit"
                                                value="{{ $user->credit }}">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">المجموعة</label>
                                            <select class="form-select" name="group_id" required="">
                                                <option value="">الرجاء الإختيار</option>
                                                @foreach($groups as $group)
                                                    <option
                                                        {{ $user->gid == $group->gid ? 'selected' : '' }}
                                                        value="{{ $group->gid }}">{{ $group->group_name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4 form-group">
                                                <label class="form-label" for="fv-type">نوع العضوية</label>
                                                <div class="form-control-wrap">
                                                    <ul class="custom-control-group">
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="type" id="type_1" required="" value="مُستخدم">
                                                                <label class="custom-control-label"
                                                                    for="type_1">مُستخدم</label>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="type" id="type_2" required="" value="إداري">
                                                                <label class="custom-control-label"
                                                                    for="type_2">إداري</label>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="col-md-4 form-group">
                                                <label class="form-label" for="fv-condition">حالة العضوية</label>
                                                <div class="form-control-wrap">
                                                    <ul class="custom-control-group">
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="condition" id="activated" value="مُفعله"
                                                                    required="">
                                                                <label class="custom-control-label"
                                                                    for="activated">مُفعله</label>
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <div
                                                                class="custom-control custom-radio custom-control-pro no-control">
                                                                <input type="radio" class="custom-control-input"
                                                                    name="condition" id="desactivated"
                                                                    value="غير مُفعله" required="">
                                                                <label class="custom-control-label"
                                                                    for="desactivated">غير مُفعله</label>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="col-md-4 form-group">
                                                <label class="form-label" for="cf-email-address">تاريخ الإنتهاء</label>
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control date-picker"
                                                        name="expire_date" value=" {{ $user->expire_date }}">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group text-center">
                                            <button type="submit" class="btn btn-lg btn-primary">تعديل
                                                المُستخدم</button>
                                        </div>
                                    </form>


                                </div>
                            </div>

                        </div>

                        {{-- </div> --}}
                        {{-- </div> --}}
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- content @e -->

    @endsection
