<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_results', function (Blueprint $table) {
            $table->id();
            $table->integer('rid');
            $table->integer('uid');
            $table->integer('quid');
            $table->text('qids');
            $table->string('category_name',1000)->nullable()->default('NULL');
            $table->string('qids_range',1000)->nullable()->default('NULL');
            $table->text('oids');
            $table->integer('start_time');
            $table->integer('end_time')->default('0');
            $table->integer('last_response');
            $table->integer('time_spent');
            $table->text('time_spent_ind');
            $table->string('score',10)->default('0');
            $table->text('scores');
            $table->text('corrects');
            $table->string('percentage',10)->default('0');
            $table->integer('q_result')->default('0');
            $table->integer('status')->default('0');
            $table->integer('institute_id')->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_results');
    }
};
