<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sms_queues', function (Blueprint $table) {
            $table->id();
            $table->integer('msg_id');
            $table->string('to');
            $table->text('text');
            $table->enum('status',['pending','sent','failed']);
            $table->datetime('date');
            $table->text('notes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sms_queues');
    }
};
