@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">الإعدادات و الضبط</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->

                <div class="nk-block">
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="{{ route('configure.post') }}" method="post">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">عدم مطالبة المستخدمين بتفعيل حساباتهم ؟
                                                        :</label>
                                                    <select class="form-select" name="auto_active" required="">
                                                        <option value="1" {{ $metas->where('name','auto_active')->first()->value == 1 ? 'selected':'' }}>عدم المطالبة</option>
                                                        <option value="2" {{ $metas->where('name','auto_active')->first()->value == 2 ? 'selected':'' }}>مُطالبة</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">إرسال رمز التفعيل عن طريق :</label>
                                                    <select class="form-select" name="verifyBy" required="">
                                                        <option value="sms" {{ $metas->where('name','verifyBy')->first()->value == 'sms' ? 'selected':'' }}>رسائل الجوال</option>
                                                        <option value="email" {{ $metas->where('name','verifyBy')->first()->value == 'email' ? 'selected':'' }}>البريد الإلكتروني</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">اسم المستخدم في موبايلي :</label>
                                                    <input type="text" class="form-control" name="sms_username" value="{{ $metas->where('name','sms_username')->first()->value }}" >
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">كلمة المرور في موبايلي :</label>
                                                    <input type="text" class="form-control" name="sms_password" value="{{ $metas->where('name','sms_password')->first()->value }}">
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">اسم المُرسل :</label>
                                                    <input type="text" class="form-control" name="sms_sender" value="{{ $metas->where('name','sms_sender')->first()->value }}">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">تفعيل التسجيل المباشر :</label>
                                                    <select class="form-select" name="open_registration" required="">
                                                        <option value="1" {{ $metas->where('name','open_registration')->first()->value == '1' ? 'selected':'' }}>نعم</option>
                                                        <option value="2" {{ $metas->where('name','open_registration')->first()->value == '2' ? 'selected':'' }}>لا</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">البريد الإلكتروني للموقع :</label>
                                                    <input type="text" class="form-control" name="email_email" value="{{ $metas->where('name','email_email')->first()->value }}">
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">اسم المُرسل للبريد الإلكتروني :</label>
                                                    <input type="text" class="form-control" name="email_sender" value="{{ $metas->where('name','email_sender')->first()->value }}">
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">المجوعة الإفتراضية للأعضاء الجدد :</label>
                                                    <select class="form-select" name="default_group" required="">
                                                        @foreach($groups as $group)
                                                            <option value="{{ $group->id }}" {{ $metas->where('name','default_group')->first()->value == $group->id ? 'selected':'' }}>
                                                                {{ $group->group_name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group text-center pt-2">
                                                    <button type="submit" class="btn btn-sm btn-primary">
                                                        حفظ البيانات
                                                    </button>
                                                </div>



                                    </form>


                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
