@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">إضافة تصنيف</h3>
                        </div>
                        <!-- .nk-block-head-content -->
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1"
                                    data-target="pageMenu"><em class="icon ni ni-menu-alt-r"></em></a>
                                <div class="toggle-expand-content" data-content="pageMenu">
                                    <ul class="nk-block-tools g-3">
                                        <li>
                                            <a href="{{ route('categories_list') }}" class="text-dark">
                                                <span>العودة للخلف</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div><!-- .toggle-wrap -->
                        </div>
                        <!-- .nk-block-head-content -->
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner p-5">
                                <form action="{{route('category.post')}}" method="post">
                                    @csrf
                                    <div class="form-group ">
                                        <label class="form-label" for="cf-full-name">اسم التصنيف</label>
                                        <input type="text" class="form-control" id="cf-full-name" name="category_name">
                                    </div>
                                    @if(request('id'))
                                    <div class="form-group ">
                                        <input type="text" class="form-control" hidden value="{{request('id')}}" name="id">
                                    </div>
                                    @endif
                                    <div class="form-group text-center">
                                        <button type="submit" class="btn btn-lg btn-primary">إرسال البيانات</button>
                                    </div>
                                </form>

                            </div><!-- .card-inner -->
                        </div><!-- .card-inner-group -->
                    </div><!-- .card -->
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->
@endsection

