@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title"> <a href="{{route('categories_list')}}">قائمة التصنيفات</a>  <i class="ni ni-arrow-left"></i> فرعي من {{$sub_category->category_name}}</h3>
                        </div>
                        <!-- .nk-block-head-content -->
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1"
                                    data-target="pageMenu"><em class="icon ni ni-menu-alt-r"></em></a>
                                <div class="toggle-expand-content" data-content="pageMenu">
                                    <ul class="nk-block-tools g-3">
                                        <li>
                                            <a href="{{ route('category.add',request('id')) }}" class="btn btn-primary">
                                                <em class="icon ni ni-plus"></em>
                                                <span>إضافة فرعي جديد</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div><!-- .toggle-wrap -->
                        </div>
                        <!-- .nk-block-head-content -->
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                @if($categories->count() != 0)
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner-group">

                            <div class="card-inner p-0">
                                <div class="nk-tb-list nk-tb-ulist is-compact">
                                    <div class="nk-tb-item nk-tb-head bg-dark-dim">

                                        <div class="nk-tb-col"><span class="sub-text">#</span></div>
                                        <div class="nk-tb-col w-75"><span class="sub-text text-dark">التصنيف</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text text-dark">تحكم</span></div>

                                    </div>
                                    <!-- .nk-tb-item -->
                                    @foreach($categories as $index => $category)
                                        <div class="nk-tb-item">
                                            <div class="nk-tb-col nk-col-md">
                                                <span>{{ $index+1 }}</span>
                                            </div>
                                            <div class="nk-tb-col nk-col-md">
                                                <span>{{ $category->category_name }}</span>
                                            </div>
                                            <div class="nk-tb-col tb-col-lg">
                                                <a href="{{route('category.edit',$category->id)}}" class="btn btn-warning">
                                                    <span>تعديل</span>
                                                    <em class="icon text-white  ni ni-pen2"></em>
                                                </a>
                                                <button class="btn btn-danger open-deleteModal" data-id="{{$category->id}}" data-bs-toggle="modal"
                                                    data-bs-target="#modalRemove" >
                                                    <span>حذف</span>
                                                    <em class="icon text-white ni ni-trash"></em>
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                    <!-- .nk-tb-item -->
                                </div><!-- .nk-tb-list -->
                            </div><!-- .card-inner -->

                            <div class="card-inner">
                                <ul class="pagination justify-content-center justify-content-md-start">
                                    {{-- {{ $categories->onEachSide(1)->links() }} --}}
                                </ul><!-- .pagination -->
                            </div><!-- .card-inner -->
                        </div><!-- .card-inner-group -->
                    </div><!-- .card -->
                </div><!-- .nk-block -->
                @else
                <div class="example-alert">
                    <div class="alert alert-warning alert-icon">
                        <em class="icon ni ni-alert-circle"></em> لم يتم العثور على أي نتائج!.
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

<div class="modal fade" tabindex="-1" id="modalRemove" style="display: none;" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body modal-body-lg text-center">
                <div class="nk-modal">
                    <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-cross bg-danger"></em>
                    <h4 class="nk-modal-title">حذف صنف</h4>
                    <div class="nk-modal-text">
                        <p class="lead">هل أنت متأكد من رغبتك بحذف هذا الصنف ؟</p>
                    </div>
                    <div class="nk-modal-action mt-5">
                        <a id="btn-delete"  class="btn btn-lg btn-mw btn-primary">حذف</a>
                        <button class="btn btn-lg btn-mw btn-danger" data-bs-dismiss="modal">رجوع</button>
                    </div>
                </div>
            </div><!-- .modal-body -->
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    $(document).on("click", ".open-deleteModal", function () {
        var categoryId = $(this).data('id');

        var url = "{{ route('category.remove','*') }}";

        url = url.replace('*', categoryId);

      $('#btn-delete').attr('href', url);


    });

</script>
@endsection
