@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">بنك الأسئله</h3>
                        </div>
                        <!-- .nk-block-head-content -->
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1"
                                    data-target="pageMenu"><em class="icon ni ni-menu-alt-r"></em></a>
                                <div class="toggle-expand-content" data-content="pageMenu">
                                    <ul class="nk-block-tools g-3">
                                        <li>
                                            <a href="#" class="btn btn-success">
                                                <em class="d-none d-sm-inline icon ni ni-download"></em>
                                                <span> إستيراد أسئلة </span>
                                            </a>
                                        </li>
                                        <li >
                                            <a href="{{route('question.add')}}" class="btn btn-primary">
                                                <em class="icon ni ni-plus"></em>
                                                <span>إضافة جديد</span>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div><!-- .toggle-wrap -->
                        </div>
                        <!-- .nk-block-head-content -->
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner position-relative card-tools-toggle">
                                <div class="card-title-group">
                                    <div class="card-tools me-n1">
                                        <ul class="btn-toolbar gx-1">
                                            <li>
                                                <a href="#" class="btn btn-icon search-toggle toggle-search"
                                                    data-target="search"><em class="icon ni ni-search"></em></a>
                                            </li><!-- li -->
                                        </ul><!-- .btn-toolbar -->
                                    </div><!-- .card-tools -->
                                </div><!-- .card-title-group -->
                                <div class="card-search search-wrap" data-search="search">
                                    <div class="card-body">
                                        <div class="search-content">
                                            <a href="#" class="search-back btn btn-icon toggle-search"
                                                data-target="search"><em class="icon ni ni-arrow-left"></em></a>
                                            <input type="text" class="form-control border-transparent form-focus-none"
                                                placeholder="Search by user or email">
                                            <button class="search-submit btn btn-icon"><em
                                                    class="icon ni ni-search"></em></button>
                                        </div>
                                    </div>
                                </div><!-- .card-search -->
                            </div><!-- .card-inner -->
                            <div class="card-inner p-0">
                                <div class="nk-tb-list nk-tb-ulist is-compact">
                                    <div class="nk-tb-item nk-tb-head">

                                        <div class="nk-tb-col"><span class="sub-text">#</span></div>
                                        <div class="nk-tb-col tb-col-lg"><span class="sub-text">السؤال</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">التصنيف</span></div>
                                        <div class="nk-tb-col tb-col-sm"><span class="sub-text">المستوى</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">تحكم</span></div>

                                    </div>
                                    <!-- .nk-tb-item -->
                                    @foreach($questions as $question)
                                        <div class="nk-tb-item">
                                            <div class="nk-tb-col">
                                                <span>1</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span class="tb-lead"> {!! $question->question !!}   </span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span>{{$question->question_category->category_name}}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span>{{$question->difficult_level->level_name}}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                    <a href="{{route('question.edit',$question->id)}}" class="btn btn-outline-info">
                                                        <span>تعديل</span>
                                                        <em class="icon text-info ni ni-pen2"></em>
                                                    </a>
                                                    <button class="btn btn-outline-danger open-deleteModal" data-id="{{$question->id}}" data-bs-toggle="modal"
                                                    data-bs-target="#modalRemove" >
                                                        <span>حذف</span>
                                                        <em class="icon text-danger ni ni-trash"></em>
                                                    </button>
                                            </div>

                                        </div>
                                     @endforeach
                                    <!-- .nk-tb-item -->

                                </div><!-- .nk-tb-list -->
                            </div><!-- .card-inner -->
                            <div class="card-inner">
                                <ul class="pagination justify-content-center justify-content-md-start">
                                    <li class="page-item"><a class="page-link" href="#">Prev</a></li>
                                    <li class="page-item"><a class="page-link" href="#">1</a></li>
                                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                                    <li class="page-item"><span class="page-link"><em
                                                class="icon ni ni-more-h"></em></span></li>
                                    <li class="page-item"><a class="page-link" href="#">6</a></li>
                                    <li class="page-item"><a class="page-link" href="#">7</a></li>
                                    <li class="page-item"><a class="page-link" href="#">Next</a></li>
                                </ul><!-- .pagination -->
                            </div><!-- .card-inner -->
                        </div><!-- .card-inner-group -->
                    </div><!-- .card -->
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

<div class="modal fade" tabindex="-1" id="modalRemove" style="display: none;" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body modal-body-lg text-center">
                <div class="nk-modal">
                    <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-cross bg-danger"></em>
                    <h4 class="nk-modal-title">حذف سؤال</h4>
                    <div class="nk-modal-text">
                        <p class="lead">هل أنت متأكد من رغبتك بحذف هذا السؤال ؟</p>
                    </div>
                    <div class="nk-modal-action mt-5">
                        <a id="btn-delete"  class="btn btn-lg btn-mw btn-primary">حذف</a>
                        <button class="btn btn-lg btn-mw btn-danger" data-bs-dismiss="modal">رجوع</button>
                    </div>
                </div>
            </div><!-- .modal-body -->
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script>
    $(document).on("click", ".open-deleteModal", function () {
        var questionId = $(this).data('id');

        var url = "{{ route('question.remove','*') }}";

        url = url.replace('*', questionId);

      $('#btn-delete').attr('href', url);


    });

</script>
@endsection
