@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">إرسال رسائل البريد الإلكتروني</h3>
                        </div>
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->

                <div class="nk-block">
                    <div class="card card-bordered ">
                        <div class="card-header border-bottom bg-orange"></div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="{{ route('email.post') }}" method="post">
                                        @csrf
                                        <div class="form-group">
                                            <label class="form-label">الموضوع :</label>
                                            <input type="text" class="form-control" name="subject">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">نص الرسالة :</label>
                                            <textarea name="message" class="summernote-basic"></textarea>
                                        </div>
                                        <div id="accordion" class="accordion form-group">
                                            <div class="accordion-item">
                                                <a href="#" class="accordion-head collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#accordion-item-1">
                                                    <h6 class="title pe-4"> مجموعات المُستخدمين</h6>
                                                    <span class="accordion-icon"></span>
                                                </a>
                                                <div class="accordion-body collapse" id="accordion-item-1"
                                                    data-bs-parent="#accordion">
                                                    <div class="accordion-inner">
                                                        <ul class="custom-control-group ">
                                                            @foreach($groups as $group)
                                                                <li>
                                                                    <div class="custom-control custom-checkbox custom-control-pro no-control pb-1">
                                                                        <input type="checkbox" class="custom-control-input" name="groups[]"
                                                                            id="categ-{{ $group->id }}" value="{{ $group->id }}">
                                                                        <label class="custom-control-label" for="categ-{{ $group->id }}">
                                                                            {{ $group->group_name }}
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group text-center pt-2">
                                            <button type="submit" class="btn btn-sm btn-primary">
                                                إرسال الرسالة
                                            </button>
                                        </div>



                                    </form>


                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@endsection
@section('styles')
<link rel="stylesheet" href="{{ asset('assets/css/editors/summernote.css') }}">
@endsection
@section('scripts')
<script src="{{ asset('assets/js/editors/summernote.js') }}"></script>

@endsection
