@extends('layouts.layout')
@section('content')

<!-- content @s -->
<div class="nk-content ">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">قائمة المستخدمين</h3>
                        </div>
                        <!-- .nk-block-head-content -->
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1"
                                    data-target="pageMenu"><em class="icon ni ni-menu-alt-r"></em></a>
                                <div class="toggle-expand-content" data-content="pageMenu">
                                    <ul class="nk-block-tools g-3">
                                        <li>
                                            <a href="#" class="btn btn-success">
                                                <em class="d-none d-sm-inline icon ni ni-download"></em>
                                                <span>تصدير النتائج (Excel) </span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#" class="btn btn-info">
                                                <em class="d-none d-sm-inline icon ni ni-book"></em>
                                                <span>سجلات العمليات</span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('user.add') }}" class="btn btn-primary">
                                                <em class="icon ni ni-plus"></em>
                                                <span>إضافة جديد</span>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div><!-- .toggle-wrap -->
                        </div>
                        <!-- .nk-block-head-content -->
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner position-relative card-tools-toggle">
                                <div class="card-title-group">
                                    <div class="card-tools me-n1">
                                        <ul class="btn-toolbar gx-1">
                                            <li>
                                                <a href="#" class="btn btn-icon search-toggle toggle-search"
                                                    data-target="search"><em class="icon ni ni-search"></em></a>
                                            </li><!-- li -->
                                        </ul><!-- .btn-toolbar -->
                                    </div><!-- .card-tools -->
                                </div><!-- .card-title-group -->
                                <div class="card-search search-wrap" data-search="search">
                                    <div class="card-body">
                                        <div class="search-content">
                                            <a href="#" class="search-back btn btn-icon toggle-search"
                                                data-target="search"><em class="icon ni ni-arrow-left"></em></a>
                                            <input type="text" class="form-control border-transparent form-focus-none"
                                                placeholder="Search by user or email">
                                            <button class="search-submit btn btn-icon"><em
                                                    class="icon ni ni-search"></em></button>
                                        </div>
                                    </div>
                                </div><!-- .card-search -->
                            </div><!-- .card-inner -->
                            <div class="card-inner p-0">
                                <div class="nk-tb-list nk-tb-ulist is-compact">
                                    <div class="nk-tb-item nk-tb-head">

                                        <div class="nk-tb-col"><span class="sub-text">#</span></div>
                                        <div class="nk-tb-col"><span class="sub-text">اسم المستخدم</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">الإسم</span></div>
                                        <div class="nk-tb-col tb-col-sm"><span class="sub-text">البريد الإلكتروني</span>
                                        </div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">رقم الجوال</span></div>
                                        <div class="nk-tb-col tb-col-xl"><span class="sub-text">المجموعة</span></div>
                                        <div class="nk-tb-col tb-col-md"><span class="sub-text">تحكم</span></div>

                                    </div>
                                    <!-- .nk-tb-item -->
                                    @foreach($users as $user)
                                        <div class="nk-tb-item">
                                            <div class="nk-tb-col nk-col-md">
                                                <span>{{ $user->id }}</span>
                                            </div>
                                            <div class="nk-tb-col">
                                                <span class="tb-lead">{{ $user->username }}</span>
                                            </div>
                                            <div class="nk-tb-col tb-col-md">
                                                <span>{{ $user->first_name }} {{ $user->last_name }}</span>
                                            </div>
                                            <div class="nk-tb-col tb-col-sm">
                                                <span>{{ $user->email }}</span>
                                            </div>
                                            <div class="nk-tb-col tb-col-md">
                                                <span>{{ $user->mobile }}</span>
                                            </div>
                                            <div class="nk-tb-col tb-col-xl">
                                                <span>
                                                    {{ $user->group->group_name ?? "" }}
                                                </span>
                                            </div>
                                            <div class="nk-tb-col tb-col-lg">
                                                <a href="{{route('user.edit',$user->id)}}" class="btn btn-outline-info">
                                                    <span>تعديل</span>
                                                    <em class="icon text-info  ni ni-pen2"></em>
                                                </a>
                                                <button class="btn btn-outline-danger open-deleteModal" data-id="{{$user->id}}" data-bs-toggle="modal"
                                                    data-bs-target="#modalRemove" >
                                                    <span>حذف</span>
                                                    <em class="icon text-danger ni ni-trash"></em>
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                    <!-- .nk-tb-item -->
                                </div><!-- .nk-tb-list -->
                            </div><!-- .card-inner -->

                            <div class="card-inner">
                                <ul class="pagination justify-content-center justify-content-md-start">
                                    {{ $users->onEachSide(1)->links() }}
                                </ul><!-- .pagination -->
                            </div><!-- .card-inner -->
                        </div><!-- .card-inner-group -->
                    </div><!-- .card -->
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

<div class="modal fade" tabindex="-1" id="modalRemove" style="display: none;" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body modal-body-lg text-center">
                <div class="nk-modal">
                    <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-cross bg-danger"></em>
                    <h4 class="nk-modal-title">حذف مستخدم</h4>
                    <div class="nk-modal-text">
                        <p class="lead">هل أنت متأكد من رغبتك بحذف هذا المستخدم ؟</p>
                    </div>
                    <div class="nk-modal-action mt-5">
                        <a id="btn-delete"  class="btn btn-lg btn-mw btn-primary">حذف</a>
                        <button class="btn btn-lg btn-mw btn-danger" data-bs-dismiss="modal">رجوع</button>
                    </div>
                </div>
            </div><!-- .modal-body -->
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    $(document).on("click", ".open-deleteModal", function () {
        var myUserId = $(this).data('id');

        var url = "{{ route('user.remove','*') }}";

        url = url.replace('*', myUserId);

      $('#btn-delete').attr('href', url);


    });

</script>
@endsection
