<?php

use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\RouteController;
use \App\Http\Controllers\UserController;
use \App\Http\Controllers\CategoryController;
use \App\Http\Controllers\QuestionController;
use \App\Http\Controllers\UserGroupController;
use \App\Http\Controllers\QuizController;

use \App\Http\Controllers\Auth\LoginController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/',                    [RouteController::class, 'home'])->name('home');
Route::get('/login',               [RouteController::class, 'login'])->name('login');


Route::middleware('auth')->group(function () {

    Route::get('/home',                     [RouteController::class, 'index'])->name('dashboard');
    Route::get('/result',                   [RouteController::class, 'resultList'])->name('results_list');
    Route::get('/setting',                  [RouteController::class, 'settings'])->name('settings');
    Route::get('/general_report',           [RouteController::class, 'generalReport'])->name('general_report');
    Route::get('/configure',                [RouteController::class, 'configure'])->name('configure');
    Route::post('/configure',               [RouteController::class, 'configurePost'])->name('configure.post');
    Route::get('/home/email',               [RouteController::class, 'email'])->name('email');
    Route::post('/home/email',              [RouteController::class, 'sendEmail'])->name('email.post');
    Route::get('/home/email_queue',         [RouteController::class, 'emailQueue'])->name('email_queue');
    Route::get('/home/email_queue/{id}',    [RouteController::class, 'emailDetails'])->name('email_details');


    Route::get('/user_data',                [RouteController::class, 'userList'])->name('user_list');
    Route::get('/user_data/add_new',            [RouteController::class, 'getAddUserPage'])->name('user.add');
    Route::post('/user_data/add_new',           [UserController::class, 'addUser'])->name('user.post');
    Route::get('/user_data/remove_user/{id}',   [UserController::class, 'removeUser'])->name('user.remove');
    Route::get('/user_data/edit_user/{id}',     [RouteController::class, 'getEditUserPage'])->name('user.edit');
    Route::post('/user_data/edit_user/{id}',    [UserController::class, 'updateUser'])->name('user.update');

    Route::get('/qbank',                    [RouteController::class, 'questionsList'])->name('questions_list');
    Route::get('/qbank/add_new',            [RouteController::class, 'getAddQuestionPage'])->name('question.add');
    Route::post('/qbank/add_new',           [QuestionController::class, 'addQuestion'])->name('question.post');
    Route::get('/qbank/edit/{id}',          [RouteController::class, 'getEditQuestionPage'])->name('question.edit');
    Route::post('/qbank/edit/{id}',         [QuestionController::class, 'editQuestion'])->name('question.put');
    Route::get('/qbank/delete/{id}',        [QuestionController::class, 'removeQuestion'])->name('question.remove');

    Route::get('/category_controller',                  [RouteController::class, 'categoriesList'])->name('categories_list');
    Route::get('/category_controller/add/{id?}',        [RouteController::class, 'getAddCategoryPage'])->name('category.add');
    Route::post('/category_controller/add',             [CategoryController::class, 'addCategory'])->name('category.post');
    Route::get('/category_controller/{id}',             [RouteController::class, 'subCategoriesList'])->name('sub_categories_list');
    Route::get('/category_controller/remove/{id}',      [CategoryController::class, 'removeCategory'])->name('category.remove');
    Route::get('/category_controller/edit/{id}',        [RouteController::class, 'getEditCategoryPage'])->name('category.edit');
    Route::post('/category_controller/edit/{id}',       [CategoryController::class, 'editCategory'])->name('category.put');

    Route::get('/group',                    [RouteController::class, 'userGroupsList'])->name('usergroup_list');
    Route::get('/group/add_new',            [RouteController::class, 'getAddGroupPage'])->name('usergroup.add');
    Route::post('/group/add_new',           [UserGroupController::class, 'addGroup'])->name('usergroup.post');
    Route::get('/group/edit/{id}',          [RouteController::class, 'getEditGroupPage'])->name('usergroup.edit');
    Route::post('/group/edit/{id}',         [UserGroupController::class, 'updateGroup'])->name('usergroup.put');
    Route::get('/group/remove/{id}',        [UserGroupController::class, 'removeGroup'])->name('usergroup.remove');


    Route::get('/quiz',                     [RouteController::class, 'quizList'])->name('quiz_list');
    Route::get('/quiz/add_new',             [RouteController::class, 'getAddQuizPage'])->name('quiz.add');
    Route::post('/quiz/add_new',            [QuizController::class, 'addQuiz'])->name('quiz.post');



    Route::get('/logout',                   [LoginController::class, 'logout'])->name('logout');
});

Auth::routes();

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
